local TILE_WIDTH = 64
local TILE_HEIGHT = 64
local LADDER_TOP, LADDER_MID, LADDER_BOT = 233, 234, 235

function main(self)
	local claw = GetClaw()
	local clawStates = ClawStates
	local action = GetMainPlane()

	-- Start:
	if self.State == 0 then
		self.HitFlags.Player = true
		self.HitRect = {-12, -24, 12, 24}
		self.Flags.AlwaysActive = true
		self.instrNo, self.instrDelay = 0, 0
		self.unfreezedWithJump = false

		self.tileCoordX = self.User[0] -- The ladder's X coord
		self.tileCoordY = self.User[1] -- The Y coord of the ladder's top

		-- calculating pixel coords from the tile coords:
		self.coordX = self.tileCoordX * TILE_WIDTH + TILE_WIDTH/2
		self.coordY = self.tileCoordY * TILE_HEIGHT + TILE_HEIGHT/2

		self.ladderHeight = self.User[2]
		self.moveLadderY = self.User[3]

		self.ladder = {}

		for n = 1, self.ladderHeight do
			self.ladder[n] = CreateObject{
				X = self.coordX,
				Y = self.coordY + TILE_HEIGHT*(n-1),
				Z = 1,
				Logic = "DoNothingNormal",
				Image = "ACTION",
				I = LADDER_MID
			}
		end
		self.ladder[1]:SetFrame(LADDER_TOP)
		self.ladder[#self.ladder]:SetFrame(LADDER_BOT)

		self.State = 1
	end

	if self.State == 2 and GetTime() > self.frameTimer then
		if claw.State == clawStates.MoveRight or claw.State == clawStates.MoveLeft then
			claw:SetAnimation("CLAW_STAND", 100)
		end
		claw.State = clawStates.Freeze
		self.State = 3
	end

	if self.State == 3 then

		if self.instrNo == 0 then
			CameraToPoint(self.SpeedX, self.SpeedY)
			self:SetFrame(3)
			self.instrDelay = GetTime() + 2000
			self.instrNo = 1
		end

		if self.instrNo == 1 and GetTime() > self.instrDelay then
			Earthquake(3000)
			PlaySound"CUSTOM_ARCANIS_QUAKE"
			self.instrDelay = GetTime()
			self.instrNo = 2
		end

		if self.instrNo == 2 then
			for _, ladderPart in ipairs(self.ladder) do
				ladderPart.Y = ladderPart.Y + math.ceil(self.moveLadderY/2) -- moving each ladder part
			end
			if self.ladder[1].Y >= self.moveLadderY*TILE_HEIGHT + self.coordY then -- reaching the final destination
				self.instrNo = 3
			end
		end

		if self.instrNo == 3 then
			for i, ladderPart in ipairs(self.ladder) do -- placing the ladder
				action:PlaceTile(self.tileCoordX, self.tileCoordY + self.moveLadderY + i - 1, ladderPart.I)
				ladderPart:Destroy()
			end
			CreateObject{
				X = 14402,
				Y = 11740,
				Z = 2000,
				name = "TriggerElevatorLong",
				image = "CUSTOM_ELEVATORLONG"
			}
			self.State = 5
		end

		if self.instrNo > 0 and GetInput"Jump" and not self.unfreezedWithJump then
			self.unfreezedWithJump = true
			CameraToClaw()
			claw.State = clawStates.MoveRight
		end

	end

	if self.State == 5 then
		CameraToClaw()
		if claw.State == clawStates.Freeze then
			claw.State = clawStates.MoveRight
		end
		CreateObject{
			X = self.X,
			Y = self.Y,
			Z = self.Z,
			logic = "DoNothing",
			image = "CUSTOM_LEVER",
			DrawFlags = self.DrawFlags,
			I = 3
		}
		self:Destroy()
	end

end

function hit(self)
	self.HitFlags.Player = false
	self.frameTimer = GetTime() + 80
	PlaySound("CUSTOM_LEVER")
	self:SetFrame(2)
	self.State = 2
end
